#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import sys
from inspect import isclass
from markdown import markdown

##############################################################################
# SETUP MPFS
##############################################################################
if os.getuid() != 0:
    print "ERROR: You must be root to run this script."
    sys.exit(1)
import mpfs.engine.process
from mpfs.common.util import normalize_unicode

mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()
##############################################################################

from mpfs.platform import v1
from mpfs.common.util import loader
from mpfs.platform.routers import DefaultRouter
from mpfs.platform.serializers import BaseSerializer
from mpfs.core.services.tanker_service import TankerHelper
from mpfs.platform.utils import trim_docstring, split_docstring
from mpfs.platform.v1.schema.serializers import I18N_PROJECT_ID, I18N_KEYSET_ID


APIS = {
    v1: ('disk',)
}


def main():
    # полностью инициализируем роутер и всё остальное, кроме диспатчеров
    # это необходимо для работы кейбилдеров
    router = DefaultRouter()
    for api in APIS:
        router.add_api(api)

    tanker_helper = TankerHelper(I18N_PROJECT_ID, I18N_KEYSET_ID, 'ru')

    for api, mod_names in APIS.iteritems():
        api_modules = router.get_api_modules(api.__name__.split('.')[-1])
        api_modules = [m for m in api_modules if m.__name__.split('.')[-2] in mod_names]
        # modules
        for mod in api_modules:
            key = tanker_helper.build_key_for_object(mod, 'title')
            title = trim_docstring(mod.__doc__)
            tanker_helper[key] = title
            # handlers
            mod_handlers = router.get_module_handlers(mod)
            for h in mod_handlers:
                title_key = tanker_helper.build_key_for_object(h, 'title')
                description_key = tanker_helper.build_key_for_object(h, 'description')
                title, description = split_docstring(trim_docstring(h.__doc__))
                tanker_helper[title_key] = title
                tanker_helper[description_key] = markdown(normalize_unicode(description))
                # handler query fields
                for f in h.query.get_fields().itervalues():
                    key = tanker_helper.build_key_for_object(f, 'title')
                    tanker_helper[key] = f.help_text
            # models fields
            serializers_mod_name = mod.__name__.replace('handlers', 'serializers')
            try:
                mod = loader.import_module(serializers_mod_name)
                for name, attr in mod.__dict__.iteritems():
                    if isclass(attr) and issubclass(attr, BaseSerializer):
                        for f in attr.fields.itervalues():
                            key = tanker_helper.build_key_for_object(f, 'title')
                            tanker_helper[key] = f.help_text
            except ImportError:
                pass
    tanker_helper.save()


if __name__ == '__main__':
   main()
