# -*- coding: utf-8 -*-
import json
import requests
from urlparse import urljoin
from urllib import urlencode


class MpfsClient(object):
    url = ''

    def __init__(self, url):
        self.url = urljoin(self.url, url)
        if not self.url.endswith('/'):
            self.url = '%s/' % self.url

    def __getattr__(self, name):
        url = urljoin(self.url, name)
        return self.__class__(url)

    def __call__(self, *args, **kwargs):
        query = urlencode(kwargs)
        url = reduce(lambda ret, a: urljoin(ret, '%s/' % a), args, self.url)
        url = '%s?%s' % (url, query)
        return requests.get(url)

    def _get_upload_url(self, uid, path, callback='http://localhost/', force=0, **kwargs):
        mpfs_resp = self.desktop.store(uid=uid, path=path, callback=callback, force=force, **kwargs)
        assert mpfs_resp.status_code == 200, mpfs_resp.status_code
        upload_url = json.loads(mpfs_resp.content)['upload_url']
        return upload_url

    def _raw_upload(self, url, data):
        kladun_resp = requests.put(url, data=data, verify=False)
        return kladun_resp

    def upload(self, uid, file_name, path, callback='http://localhost/', force=0, **kwargs):
        with open(file_name) as f:
            data = f.read()
        return self._raw_upload(self._get_upload_url(uid, path, callback, force, **kwargs), data)
