import json

import requests
from optparse import OptionParser, Option

option_list = (
    Option(
        '-t', '--tool',
        action='store',
        dest='tool',
        type='string',
        help='"dump" or "restore"'
    ),
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        help='user uid'
    ),
    Option(
        '-c', '--context',
        action='store',
        dest='context',
        type='string',
        help='"app" or "user"'
    ),
    Option(
        '-a', '--app_id',
        action='store',
        dest='app_id',
        type='string',
        help='application id required if context "app"'
    ),
    Option(
        '-d', '--db',
        action='store',
        dest='db',
        type='string',
        help='database name'
    ),
    Option(
        '-b', '--base_url',
        action='store',
        dest='base_url',
        type='string',
        help='host',
        default='http://localhost',
    ),
    Option(
        '-f', '--file',
        action='store',
        dest='file',
        type='string',
        help='file name'
    ),
)

usage = "usage: %prog -h"
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def dump_db():
    opt_dict = vars(options)
    url = '%(base_url)s/v1/%(uid)s/data/%(context)s/databases/%(db)s/deltas' % opt_dict
    revision = 0
    total = 1
    headers = {'Authorization': 'Internal client_id=%(app_id)s;client_name=%(app_id)s' % opt_dict}

    with open(options.file, 'w') as f:
        while total > revision:
            resp = requests.get(url, params={'base_revision': revision}, headers=headers).json()
            total = resp['revision']
            for delta in resp['items']:
                revision = delta['revision']
                f.write(json.dumps(delta))


def restore_db():
    opt_dict = vars(options)
    url = '%(base_url)s/v1/%(uid)s/data/%(context)s/databases/%(db)s/deltas' % opt_dict
    headers = {'Authorization': 'Internal client_id=%(app_id)s;client_name=%(app_id)s' % opt_dict}

    with open(options.file, 'r') as f:
        for raw_delta in f:
            if not raw_delta.strip():
                continue
            delta = json.loads(raw_delta)
            headers['If-Match'] = delta['base_revision']
            print requests.post(url, json=delta, headers=headers).content
            print delta['revision']

if __name__ == "__main__":
    if options.tool == 'dump':
        dump_db()
    elif options.tool == 'restore':
        restore_db()
