#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys, os
import random
import hashlib


import mpfs.core.base as core
import mpfs.core.errors as errors
from mpfs.core.filesystem.base import Filesystem

UID = 31775450

core.init_user(UID)
filesystem = Filesystem()
filesystem.mkdir(UID, '/disk/folder1/')
filesystem.mkdir(UID, '/disk/folder2/')
filesystem.mkdir(UID, '/disk/folder3/')
filesystem.mkdir(UID, '/disk/folder4/')
filesystem.mkdir(UID, '/disk/15files/')
filesystem.mkdir(UID, '/disk/40files/')
filesystem.mkdir(UID, '/disk/50files/')
filesystem.mkdir(UID, '/disk/folder1/subfolder1/')
filesystem.mkdir(UID, '/disk/folder1/subfolder2/')
filesystem.mkdir(UID, '/disk/folder1/subfolder3/')
filesystem.mkdir(UID, '/disk/folder1/subfolder4/')
filesystem.mkdir(UID, '/disk/folder1/subfolder1/subsubfolder1/')
filesystem.mkdir(UID, '/disk/folder1/subfolder1/subsubfolder2/')
filesystem.mkdir(UID, '/disk/folder1/subfolder1/subsubfolder3/')
filesystem.mkdir(UID, '/disk/folder1/subfolder1/subsubfolder4/')
filesystem.mkdir(UID, '/disk/folder2/subfolder1/')
filesystem.mkdir(UID, '/disk/folder2/subfolder2/')
filesystem.mkdir(UID, '/disk/folder2/subfolder3/')
filesystem.mkdir(UID, '/disk/folder2/subfolder4/')
filesystem.mkdir(UID, '/disk/folder2/subfolder5/')
filesystem.mkdir(UID, '/disk/folder3/subfolder1/')
filesystem.mkdir(UID, '/disk/folder3/subfolder2/')
filesystem.mkdir(UID, '/disk/folder3/subfolder3/')
filesystem.mkdir(UID, '/disk/folder3/subfolder4/')
filesystem.mkdir(UID, '/disk/folder4/subfolder1/')
filesystem.mkdir(UID, '/disk/folder4/subfolder2/')
filesystem.mkdir(UID, '/disk/folder4/subfolder3/')
filesystem.mkdir(UID, '/disk/folder4/subfolder4/')
filesystem.mkdir(UID, '/disk/folder4/subfolder5/')

filetypes = [ { 'suffix': 'txt', 'mime': 'text/plain' },
              { 'suffix': 'jpg', 'mime': 'image/jpeg' }, 
              { 'suffix': 'exe', 'mime': 'application/exe' }, ]

for i in range(1, 15):    
    ftype = filetypes[random.randint(0, 2)]
    size  = random.randint(1, 2000000000)
    filename = 'file' + str(i) + '.' + ftype['suffix']
    
    md5 = hashlib.md5()
    md5.update(str(filename))
    digest = md5.hexdigest()
    
    value = {
        'mimetype': ftype['mime'],
        'meta': { 'md5': str(digest) },
        'size': str(size), 
    }
    filesystem.mkfile(UID, '/disk/15files/' + filename, **value)


for i in range(1, 40):    
    ftype = filetypes[random.randint(0, 2)]
    size  = random.randint(1, 2000000000)
    filename = 'superfile' + str(i) + '.' + ftype['suffix']
    
    md5 = hashlib.md5()
    md5.update(str(filename))
    digest = md5.hexdigest()
    
    value = {
        'mimetype': ftype['mime'],
        'meta': { 'md5': str(digest) },
        'size': str(size), 
    }
    filesystem.mkfile(UID, '/disk/40files/' + filename, **value)


for i in range(1, 50):    
    ftype = filetypes[random.randint(0, 2)]
    size  = random.randint(1, 2000000000)
    filename = 'megafile' + str(i) + '.' + ftype['suffix']
    
    md5 = hashlib.md5()
    md5.update(str(filename))
    digest = md5.hexdigest()
    
    value = {
        'mimetype': ftype['mime'],
        'meta': { 'md5': str(digest) },
        'size': str(size),
    }
    filesystem.mkfile(UID, '/disk/50files/' + filename, **value)


