#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import subprocess
import getpass
from optparse import OptionParser, Option
from megagrepformat import work

usage = "usage: python %prog -h"
option_list = (
    Option(
        '-u', '--uid',
        dest='uid',
        type='string',
        help='user id, 123',
        default='',
    ),
    Option(
        '-p', '--path',
        dest='path',
        type='string',
        help='resource path, /disk/file.bmp',
        default='',
    ),
    Option(
        '-a', '--action',
        dest='action',
        type='string',
        help='action with file, upload, delete, etc..',
        default='',
    ),
    Option(
        '-d', '--date',
        dest='date',
        type='string',
        help='action date, 20131228',
        default='',
    ),
)

username = getpass.getuser()
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

p = subprocess.Popen(['megagrep-support.sh', options.uid, options.path, options.action, options.date], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
a, e = p.communicate()

MPFS_RESULT = open('/tmp/mpfs_fcgi-access_result_%s.log' % username, 'r')
WEBDAV_RESULT = open('/tmp/yadrop_access_result_%s.log' % username, 'r')

files = {
    'webdav': WEBDAV_RESULT,
    'mpfs': MPFS_RESULT,
}

work(files, options.path, options.action)
