#!/bin/bash

trap "{ pgrep -u `whoami` gzip|xargs kill;rm fcgi-access*; exit 0; }" SIGINT SIGTERM

uid=$1
resource=$2
action=$3
date=$4

find /u0/archive_logs/mpfs|grep fcgi-access|grep $date >> fcgi-access
find /u0/archive_logs/webdav|grep yadrop_access|grep $date >> fcgi-access

let threads=`cat /proc/cpuinfo |grep processor -c`-3
if [ $threads -le 1 ];
then
    threads=1
fi

let split_number=$(echo "`wc -l fcgi-access |awk {'print $1'}`/$threads")

if [ $split_number -lt 1 ];
then
    echo "No such files"
    exit 0
fi

split -l $split_number fcgi-access fcgi-access_parts

function thread {
    file=$1
    uid=$2
    path=$3
    for i in $(cat $file)
    do 
        zcat $i|grep "uid=$uid" > $(basename "$i")$file.log
    done
}

for file in fcgi-access_parts*
do 
    thread $file $uid $resource &
done

gcount=1

while [ $gcount -gt 0 ]
do
    gcount=$(ps -u `whoami`|grep -c gzip) 
    echo "gcount:$gcount"
    sleep 1
done

cat mpfs_fcgi-access*.log|sort > /tmp/mpfs_fcgi-access_result_`whoami`.log

cat yadrop_access*.log|sort > /tmp/yadrop_access_result_`whoami`.log

rm mpfs_fcgi-access*
rm fcgi-access*
rm yadrop_access*
