#!/bin/bash

#http://wiki.yandex-team.ru/users/triklozoid/poiskpologstore

trap "{ ps -u `whoami`|grep -v ssh|awk {'print $1'}|grep -v PID|xargs kill;rm tl_3*; exit 0; }" SIGINT SIGTERM

name="fcgi-access"
date=`date +%Y%m%d -d "yesterday"`
what="get_updates"


find /u[0,1]/archive_logs/sync|grep $name|grep $date | fgrep -v export > $name

let threads=`nproc`

let number=$(echo "`wc -l $name |awk {'print $1'}`/$threads")
if [ $number -lt 1 ];
then
    echo "No such files"
    exit 0
fi

split -l $number $name tl_3

function thread {
    file=$1
    what=$2
    for i in $(cat $file)
    do 
        host=$(basename $(dirname $i))
	if [ -s $i ]; then
		zcat $i|fgrep $what| sed 's/.*u=//'|sed 's/&.*//'|sort|uniq >> $file.log
	fi
    done
}

for file in tl_3*
do 
    thread $file "$what" &
done

gcount=1

while [ $gcount -gt 0 ]
do
    let gcount=$(ps -u `whoami`|grep -c gzip)+$(ps -u `whoami`|grep -c grep)-3
    sleep 1
done

cat tl_3*.log|sort|uniq > "`date +%Y%m%d -d "yesterday"`_get_updates_uids.log"

rm tl_3*

