#!/bin/bash

#http://wiki.yandex-team.ru/users/triklozoid/poiskpologstore

trap "{ ps -u `whoami`|awk {'print $1'}|xargs kill;rm tl_3*; exit 0; }" SIGINT SIGTERM

name=$1   # имя лога (используется для паттерна для grep)
date=$2   # дата в формате 20151201
what=$3   # что ищем
where=$4  # где парсить в /u0/archive_logs/ - возможные значения: mpfs, webdav, worker. Можно перечислять через запятую (без пробелов!!): mpfs,webdav

if [[ -z $where ]]
then
    where=mpfs,webdav
fi

if [[ "$where" == *","* ]]
then
    # если ищем по нескольким папкам, все сложнее - надо убрать в скобки {} и сделать eval
    eval find /u0/archive_logs/{"$where"}|grep "$name"|grep -E "$date" > "$name"
else
    find /u0/archive_logs/"$where"|grep "$name"|grep -E "$date" > "$name"
fi

let threads=`cat /proc/cpuinfo |grep processor -c`-2
let files_qty=`wc -l $name`
if [ "$files_qty" -lt "$threads" ];
then
    let threads="$files_qty"
fi

let number=$(echo "`wc -l $name |awk {'print $1'}`/$threads")
if [ "$number" -lt 1 ];
then
    echo "No such files"
    exit 0
fi

split -l "$number" "$name" tl_3

function thread {
    file="$1"
    what="$2"
    while read i
    do
        host=$(basename $(dirname "$i"))
        if [ -s "$i" ]; then
            zcat "$i"|grep "$what"| awk -v host="$host" {'print host ":" $0'} >> "$file".log
        fi
    done < "$file"
}

for file in tl_3*
do
    thread "$file" "$what" &
done

gcount=1

while [ $gcount -gt 0 ]
do
    let gcount=$(ps -u `whoami`|grep -c gzip)+$(ps -u `whoami`|grep -c grep)-3
    sleep 1
done

cat tl_3*.log > result.log

rm tl_3*
