from collections import defaultdict
from datetime import datetime
import sys
'''
https://st.yandex-team.ru/CHEMODAN-19730
How to use:

cat /var/log/mpfs/service-indexer.log | python indexer_services_stat.py  > result.tsv
'''


def parse_info(info):
    result = dict()
    for key_value in info.split('\t'):
        key, value = key_value.split('=', 1)
        result[key] = value
    return result


def round_date_time(date, time):
    dt = datetime.strptime('%s %s' % (date, time), '%Y-%m-%d %H:%M:%S,%f')
    return dt.strftime('%Y-%m-%d %H')


result = defaultdict(lambda: defaultdict(lambda: defaultdict(int)))
for line in sys.stdin:
    if not ('status=' in line and
            'type=service_response' in line and
            'obj=' in line):
        continue
    try:
        date, time, _, _, _, _, info = line.strip('\n').split(' ', 6)
        parsed_info = parse_info(info)
        rounded_date = round_date_time(date, time)
        result[rounded_date][parsed_info['obj']][parsed_info['status']] += 1
    except Exception:
        pass

for date, tmp in result.iteritems():
    for obj, values in tmp.iteritems():
        print "%s\t%s\t%i\t%i" % (date, obj, values['success'], values['failure'])
