#!/usr/bin/python
# -*- coding: utf-8 -*-


import pymongo
import time
import datetime
from collections import defaultdict
from dateutil.relativedelta import relativedelta

from mpfs.metastorage.mongo.projects.disk import db


all_invites = list(db.group_invites.find())

def get_month_day_range(date):
    return date + relativedelta(day=1, months=+1, days=-1)

emails = defaultdict(int)


def get_month_last_day(t):
    """
        Для timestamp возвращается название месяца и timestamp последнего дня
    """
    d = datetime.datetime.fromtimestamp(t).date()
    return int(time.mktime(get_month_day_range(d).timetuple())) + 24 * 60 * 60 - 1

def get_month(t):
    d = datetime.datetime.fromtimestamp(t)
    return d.year, d.month, d.strftime("%Y %B")

by_date = defaultdict(int)
dates = {}
for each in all_invites:
    serv = each['universe_service']
    if serv == 'email':
        serv = each['universe_login'].split('@')[1]
    emails[serv]+=1
    y, m, strf = get_month(each['ctime'])
    dates[(y, m)] = strf
    by_date[strf]+=1

sorted_emails = sorted(emails.iteritems(), key=lambda x: x[1], reverse=True)[:50]

for addr, count in sorted_emails:
    print addr, '\t', count
print
for k,v in sorted(dates.iteritems(), key=lambda d: (d[0][0], d[0][1])):
    print v, '\t', by_date.get(v)
