package ru.yandex.chemodan.app.notes.api;

import ru.yandex.chemodan.app.notes.core.ResultWithRevision;
import ru.yandex.chemodan.http.CommonHeaders;
import ru.yandex.commune.a3.action.http.HttpStatus;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.result.NoContent;

/**
 * @author tolmalev
 */
public class AddRevisionInterceptor implements ActionInvocationInterceptor {

    public static final String X_ACTUAL_REVISION = "X-Actual-Revision";

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.RESPONSE_INTERCEPTOR_ORDER;
    }

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        Object result = invocation.invoke();

        if (result instanceof ResultWithRevision) {
            ResultWithRevision withRev = (ResultWithRevision) result;
            invocation.getContext().getHttpContext().addHeader(X_ACTUAL_REVISION, Long.toString((withRev).rev));
            invocation.getContext().getHttpContext().addHeader(CommonHeaders.ACCESS_CONTROL_EXPOSE_HEADERS,
                    "Cache-Control, Content-Language, Content-Type, Expires, Last-Modified, Pragma, "
                    + X_ACTUAL_REVISION);

            if (withRev.created) {
                invocation.getContext().getHttpContext().setStatusCode(HttpStatus.CREATED.getStatusCode());
            }

            if (withRev.result == null) {
                invocation.getContext().getHttpContext().setStatusCode(HttpStatus.NO_CONTENT.getStatusCode());
                return NoContent.cons();
            }

            return withRev.result;
        }

        return result;
    }
}
