package ru.yandex.chemodan.app.notes.api;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.chemodan.app.notes.core.ResultWithRevision;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestHeader;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.utils.Language;

/**
 * @author tolmalev
 * @author vpronto
 */
@ActionContainer
@AllArgsConstructor
public class CommonActions {
    private final NotesManager notesManager;

    @Path(value = "/init", methods = {HttpMethod.POST, HttpMethod.PUT})
    public ResultWithRevision<Void> init(
            @RequestParam("__uid") DataApiUserId uid,
            @RequestParam("locale") Option<String> localeStr,
            @RequestHeader(value = "X-Request-Id", required = false) Option<String> requestId,
            @RequestHeader(value = "User-Agent", required = false) Option<String> userAgent)
    {
        return notesManager.init(uid, requestId, localeStr.flatMapO(Language.R::fromValueO), userAgent);
    }
}
