package ru.yandex.chemodan.app.notes.api;

import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.chemodan.app.notes.core.TagsManager;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.bender.ISOInstantUnmarshaller;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.chemodan.web.convert.ConvertToLanguage;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;

/**
 * @author tolmalev
 */
@Import({
        A3JettyContextConfiguration.class,
        Tvm2ServletFilterContextConfiguration.class,
})
public class NotesActionsContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ""
        ));
    }

    @Bean
    public TagsActions tagsActions(TagsManager tagsManager) {
        return new TagsActions(tagsManager);
    }

    @Bean
    public NotesActions notesActions(NotesManager manager) {
        return new NotesActions(manager);
    }

    @Bean
    public NotesContentActions notesContentActions(NotesManager notesManager) {
        return new NotesContentActions(notesManager);
    }

    @Bean
    public NotesAttachmentActions notesAttachmentActions(NotesManager notesManager) {
        return new NotesAttachmentActions(notesManager);
    }

    @Bean
    public CommonActions commonActions(NotesManager notesManager) {
        return new CommonActions(notesManager);
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {

        BenderMapper mapper = new BenderMapper(BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Instant.class, new ReadableInstantConfigurableMarshaller(ISODateTimeFormat.dateTime()))
                        .add(Instant.class, new ISOInstantUnmarshaller())
                        .build()
        ));

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator
                .addJsonBendingWithoutInvocationInfo(mapper).getBuilder()

                .addConverters(Cf.list(new ConvertToDataapiUser(), new ConvertToLanguage()))

                .addInvocationInterceptors(Cf.list(
                        new AddRevisionInterceptor(),
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
        ;

        return configurator.configure();
    }
}
