package ru.yandex.chemodan.app.notes.api;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.chemodan.app.notes.core.ResultWithRevision;
import ru.yandex.chemodan.app.notes.core.model.notes.Note;
import ru.yandex.chemodan.util.http.RequestUtils;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestHeader;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author tolmalev
 * @author vpronto
 */
@ActionContainer
@AllArgsConstructor
public class NotesContentActions {

    private final NotesManager notesManager;

    @Path(value = "/notes/{id}/content", methods = HttpMethod.GET)
    public void getNoteContentAction(
            @RequestParam("__uid") DataApiUserId uid,
            @PathParam("id") String id,
            @SpecialParam HttpServletRequestX req,
            @SpecialParam HttpServletResponseX resp) {
        Option<Long> ifNonMatch = RequestUtils.getIfNonMatchAsLong(req);
        notesManager.getContent(uid, id, resp, ifNonMatch);
    }

    @Path(value = "/notes/{id}/content", methods = HttpMethod.PUT)
    public void putNoteContentAction(
            @RequestParam("__uid") DataApiUserId uid,
            @PathParam("id") String id,
            @RequestHeader(value = "X-Request-Id", required = false) Option<String> requestId,
            @RequestHeader(value = "X-Mtime", required = false) Option<Instant> clientTime,
            @SpecialParam HttpServletRequestX req,
            @SpecialParam HttpServletResponseX resp) {
        notesManager.putContent(
                uid, id, requestId, clientTime.getOrElse(Instant.now()), false, req, resp);
    }

    @Path(value = "/notes/{id}/content_with_meta", methods = HttpMethod.PUT)
    public void putNoteContentWithMetaAction(
            @RequestParam("__uid") DataApiUserId uid,
            @PathParam("id") String id,
            @RequestHeader(value = "X-Request-Id", required = false) Option<String> requestId,
            @RequestHeader(value = "X-Mtime", required = false) Option<Instant> clientTime,
            @SpecialParam HttpServletRequestX req,
            @SpecialParam HttpServletResponseX resp) {
        notesManager.putContent(
                uid, id, requestId, clientTime.getOrElse(Instant.now()), true, req, resp);
    }

    @Path(value = "/notes/{id}/clone_with_new_content", methods = HttpMethod.PUT)
    public ResultWithRevision<Note> cloneNoteWithNewContentAction(
            @RequestParam("__uid") DataApiUserId uid,
            @PathParam("id") String id,
            @RequestHeader(value = "X-Request-Id", required = false) Option<String> requestId,
            @RequestHeader(value = "X-Mtime", required = false) Option<Instant> clientTime,
            @SpecialParam HttpServletRequestX req)
    {
        return notesManager.createNoteWithContent(
                uid, Option.of(id), requestId, clientTime.getOrElse(Instant.now()), req);
    }

}
