package ru.yandex.chemodan.app.notes.api;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.ResultWithRevision;
import ru.yandex.chemodan.app.notes.core.TagsManager;
import ru.yandex.chemodan.app.notes.core.model.tag.Tag;
import ru.yandex.chemodan.app.notes.core.model.tag.TagBase;
import ru.yandex.chemodan.app.notes.core.model.tag.TagPatch;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.BoundByBender;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestHeader;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 * @author vpronto
 */
@ActionContainer
@AllArgsConstructor
public class TagsActions {

    private final TagsManager tagManager;

    @Path(value = "/tags", methods = HttpMethod.PUT)
    public ResultWithRevision<Tag> createTag(
            @RequestParam("__uid") DataApiUserId uid,
            @BoundByBender TagBase tagBase)
    {
        return tagManager.createTag(uid, tagBase);
    }

    @Path(value = "/tags/{id}", methods = HttpMethod.DELETE)
    public ResultWithRevision<Void> deleteTag(
            @RequestParam("__uid") DataApiUserId uid,
            @PathParam("id") long id)
    {
        return tagManager.deleteTag(uid, id);
    }

    @Path(value = "/tags/{id}", methods = HttpMethod.PATCH)
    public ResultWithRevision<?> patchTag(
            @RequestParam("__uid") DataApiUserId uid,
            @RequestHeader(value = "X-Request-Id") Option<String> requestId,
            @PathParam("id") long id,
            @BoundByBender TagPatch tagPatch)
    {
        return tagManager.patchTag(uid, id, tagPatch, requestId);
    }

    @Path(value = "/tags", methods = HttpMethod.GET)
    public TagsList listTags(@RequestParam("__uid") DataApiUserId uid) {
        return new TagsList(tagManager.listTags(uid));
    }

    @ActionResultPojo
    @BenderBindAllFields
    private static class TagsList {
        public final ListF<Tag> items;

        private TagsList(ListF<Tag> items) {
            this.items = items;
        }
    }
}
