package ru.yandex.chemodan.app.notes.core;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mds.MdsConfig;
import ru.yandex.chemodan.tvm2.SingleClientResolver;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.mds.Mds;
import ru.yandex.inside.mds.MdsHosts;
import ru.yandex.inside.mds.MdsInternalStaticProxies;
import ru.yandex.inside.mds.MdsMetrics;
import ru.yandex.inside.mds.MdsNamespace;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.ip.HostPort;

/**
 * @author vpronto
 */
@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class MdsContextConfiguration {

    @Bean
    @OverridableValuePrefix("notes")
    MdsConfig mdsConfig() {
        return new MdsConfig();
    }

    @Bean
    @OverridableValuePrefix("mds.read")
    public HttpClientConfigurator mdsReadHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("mds.write")
    public HttpClientConfigurator mdsWriteHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    Mds mds(MdsConfig mdsConfig,
            Tvm2 tvm2,
            @Value("${tvm.mulca.client-id}") int mulcaClientId,
            @Value("${mulca.tvm2.enabled}") boolean tvm2Enabled)
    {
        MdsNamespace mdsNamespace = new MdsNamespace(mdsConfig.getNamespace(), mdsConfig.getAuthHeader(), Option.empty());
        MdsHosts mdsHosts = new MdsHosts(
                new HostPort(mdsConfig.getReadHost(), mdsConfig.getReadPort()),
                new HostPort(mdsConfig.getWriteHost(), mdsConfig.getWritePort()),
                new MdsInternalStaticProxies(Cf.list(new HostPort(mdsConfig.getUploadHost(), mdsConfig.getUploadPort()))));

        HttpClientConfigurator readConfigurator = mdsReadHttpClientConfigurator();
        HttpClientConfigurator writeConfigurator = mdsWriteHttpClientConfigurator();

        if (tvm2Enabled && tvm2 != null) {
            readConfigurator.setAddServiceTicketInterceptor(Optional.of(tvm2.serviceTicketInterceptor(new SingleClientResolver(mulcaClientId))));
            writeConfigurator.setAddServiceTicketInterceptor(Optional.of(tvm2.serviceTicketInterceptor(new SingleClientResolver(mulcaClientId))));
        }

        return new Mds(mdsHosts, mdsNamespace, readConfigurator.configure(), writeConfigurator.configure(), MdsMetrics.EMPTY);
    }

    @Bean
    NotesContentManager contentMdsManager(Mds mds) {
        return new NotesContentMdsManager(mds);
    }

}
