package ru.yandex.chemodan.app.notes.core;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.model.notes.Attachment;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentAddition;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentCreationResult;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentQuery;
import ru.yandex.chemodan.app.notes.core.model.notes.Attachments;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.inside.utils.Language;

/**
 * @author vpronto
 */
public interface NotesAttachmentsManager {

    String NOTE_REVISION_CREATED = "note_revision_created";
    String NOTE_NAME = "note_name";
    String NOTE_ID = "note_id";
    String NOTE_REVISION_DELETED = "note_revision_deleted";
    String NOTE_ATTACHMENT_MTIME = "note_attachment_mtime";
    String INITIAL_NOTE_PREFIX = "initial_";
    String NOTES_SOURCE = "notes";
    SetF<String> META_FIELDS = Cf.set(
            "mediatype", NOTE_REVISION_CREATED, NOTE_REVISION_DELETED, "resource_id", NOTE_NAME, NOTE_ATTACHMENT_MTIME);

    boolean needInit(DataApiUserId uid);

    void userInit(DataApiUserId uid, Language locale);

    ResultWithRevision<Attachment> getAttachment(DataApiUserId uid, String noteId, String resourceId);

    ResultWithRevision<Attachments> getAttachments(AttachmentQuery query);

    ResultWithRevision<AttachmentCreationResult> addAttachments(AttachmentAddition addition, Instant mtime);

    ResultWithRevision<Void> deleteAttachment(
            DataApiUserId uid, String noteId, String resourceId, Option<Long> revision, Instant mtime);

    ListF<MpfsFileInfo> getAttachmentsInfos(DataApiUserId uid, String noteId, Option<Long> rev);

    void copyAttachments(DataApiUserId uid, String srcId, String dstId, long dstRev, Option<ListF<String>> resourceIds);

    void removeAttachmentsFromMpfs(DataApiUserId uid, String noteId);

    ListF<String> copyInitialAttachments(DataApiUserId uid, String noteId, Language lang, Instant mtime, long rev);
}
