package ru.yandex.chemodan.app.notes.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

import org.apache.commons.io.IOUtils;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.mds.Mds;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mds.MdsPostResponse;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.io.OutputStreamX;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author vpronto
 */
public class NotesContentMdsManager implements NotesContentManager {

    private final static Logger logger = LoggerFactory.getLogger(NotesContentMdsManager.class);
    private final DynamicProperty<Boolean> useEmptyFilename = new DynamicProperty<>("notes-empty-filename", false);

    private final Mds mds;

    public NotesContentMdsManager(Mds mds) {
        this.mds = mds;
    }

    public MdsFileKey put(String id, DataApiUserId uid, long revision, byte[] data) {
        String key = createMdsKey(id, uid, revision);
        MdsPostResponse upload = mds.upload(key, new ByteArrayInputStreamSource(data));
        return upload.getKey();
    }

    public void get(MdsFileKey key, OutputStream outputStream) {
        try (InputStream in = mds.getInputStreamSource(key).getInputStreamX();
                OutputStreamX streamX = OutputStreamX.wrap(outputStream)) {
            IOUtils.copy(in, streamX);
        } catch (Exception e) {
            logger.error("can't get content", e);
            throw ExceptionUtils.translate(e);
        }
    }

    public void deleteData(MdsFileKey key) {
        mds.delete(key);
    }

    private String createMdsKey(String id, DataApiUserId uid, long revision) {
        if (useEmptyFilename.get()) {
            return "";
        }
        return uid.serialize() + "-" + id + "-" + revision + "-" + UUID.randomUUID();
    }
}
