package ru.yandex.chemodan.app.notes.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.DataApiBaseContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.notes.dao.NotesDao;
import ru.yandex.chemodan.app.notes.dao.NotesRequestsDao;
import ru.yandex.chemodan.app.notes.dao.NotesRevisionsDao;
import ru.yandex.chemodan.app.notes.dao.configuration.DataSourceNotesContextConfiguration;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DataSourceNotesContextConfiguration.class,
        MdsContextConfiguration.class,
        DataApiBaseContextConfiguration.class,
        DynamicPropertiesContextConfiguration.class,
        ProdBlackboxContextConfiguration.class
})
public class NotesCoreContextConfiguration {

    @Bean
    public TagsManager tagManager(DataApiManager dataApiManager, NotesManager notesManager, NotesRequestsDao requestsDao) {
        return new TagsManagerImpl(dataApiManager, notesManager, requestsDao);
    }

    @Bean
    public NotesAttachmentsProperties notesAttachmentsProperties() {
        return new NotesAttachmentsProperties();
    }

    @Bean
    public NotesManager notesManager(DataApiManager dataApiManager, NotesDao notesDao,
            NotesRevisionsDao notesRevisionsDao, NotesRequestsDao requestsDao, NotesContentManager contentManager,
            NotesAttachmentsManager notesAttachmentsManager,
            BazingaTaskManager bazingaTaskManager,
            Blackbox2 blackbox2,
            @Value("${notes.sync-attach-resource-ids.threads}") int syncThreadsCount,
            @Value("${notes.sync-attach-resource-ids-delay}") Duration attachmentsSyncDelay,
            @Value("${notes.retries-on-conflict-count}") int retriesOnConflictCount)
    {
        ExecutorService syncAttachmentsResourcesService = Executors.newFixedThreadPool(syncThreadsCount);
        return new NotesManagerImpl(dataApiManager, notesDao, notesRevisionsDao, requestsDao, contentManager,
                notesAttachmentsManager, bazingaTaskManager, blackbox2,
                syncAttachmentsResourcesService, attachmentsSyncDelay,
                retriesOnConflictCount);
    }

    @Bean
    public NotesAttachmentsManager attachmentsManager(MpfsClient mpfsClient, NotesDao notesDao,
            NotesAttachmentsProperties notesAttachmentsProperties,
            @Value("${notes.callback-url}") String callbackUrl)
    {
        return new NotesAttachmentsManagerImpl(mpfsClient, notesDao, notesAttachmentsProperties, callbackUrl);
    }
}
