package ru.yandex.chemodan.app.notes.core;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.model.notes.Attachment;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentAddition;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentCreationResult;
import ru.yandex.chemodan.app.notes.core.model.notes.AttachmentQuery;
import ru.yandex.chemodan.app.notes.core.model.notes.Attachments;
import ru.yandex.chemodan.app.notes.core.model.notes.Note;
import ru.yandex.chemodan.app.notes.core.model.notes.NoteCreation;
import ru.yandex.chemodan.app.notes.core.model.notes.NotePatch;
import ru.yandex.chemodan.app.notes.core.model.notes.NoteWithMdsKey;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author tolmalev
 */
public interface NotesManager {

    ResultWithRevision<Void> init(DataApiUserId uid, Option<String> requestId,
            Option<Language> locale, Option<String> userAgent);
    Database findOrCreateDb(DataApiUserId uid);

    ListF<Note> listNotes(DataApiUserId uid);
    ResultWithRevision<NoteWithMdsKey> findNote(DataApiUserId uid, String id, boolean getMdsKey);
    ResultWithRevision<Note> createNote(DataApiUserId uid, NoteCreation base, Option<String> requestId);
    ResultWithRevision<Void> deleteNote(DataApiUserId uid, String id, HttpServletRequestX req);
    ResultWithRevision<?> patchNote(
            DataApiUserId uid, String id, NotePatch patch, Option<String> requestId, boolean forceMtimeUpdate);
    void updateMtimeAndAttachResourceIds(
            DataApiUserId uid, String noteId, Option<Instant> attachMtime, ListF<String> resourceIds);
    void updateMtime(DataApiUserId uid, String noteId, Instant mtime);
    void getContent(DataApiUserId uid, String id, HttpServletResponseX responseX, Option<Long> ifNonMatch);
    void putContent(DataApiUserId uid, String id, Option<String> requestId, Instant clientTime, boolean extendedContent,
                      HttpServletRequestX req, HttpServletResponseX resp);

    ResultWithRevision<Attachment> getAttachment(DataApiUserId uid, String noteId, String resourceId);

    ResultWithRevision<Attachments> getAttachments(AttachmentQuery query);

    ResultWithRevision<AttachmentCreationResult> addAttachments(AttachmentAddition addition, Instant mtime);

    ResultWithRevision<Void> deleteAttachment(
            DataApiUserId uid, String noteId, String resourceId,
            Option<Long> revision, Instant mtime, Option<String> userAgent);

    void synchronizeAttachments(DataApiUserId uid, String noteId, Option<Instant> actionMtime);

    ResultWithRevision<Note> createNoteWithContent(
            DataApiUserId uid, Option<String> sourceIdO,
            Option<String> requestId, Instant clientTime, HttpServletRequestX req);

    ResultWithRevision<Note> createPublicNote(Language lang, String title, String snippet, String content);

    ResultWithRevision<Note> createInitialNote(DataApiUserId uid);

    void scheduleNotesRemoval(DataApiUserId uid, Instant noteDeletionTime);
    void removeDeletedNotes(DataApiUserId uid, boolean withReschedule);
}
