package ru.yandex.chemodan.app.notes.core;

import lombok.Data;

/**
 * @author tolmalev
 */
@Data
public class ResultWithRevision<T> {
    public final long rev;
    public final T result;
    public final boolean created;

    public ResultWithRevision(long rev) {
        this(null, rev);
    }

    public ResultWithRevision(T result, long rev) {
        this(result, rev, false);
    }

    public ResultWithRevision(T result, long rev, boolean created) {
        this.rev = rev;
        this.result = result;
        this.created = created;
    }

    public ResultWithRevision<T> wasCreated() {
        return new ResultWithRevision<>(result, rev, true);
    }
}
