package ru.yandex.chemodan.app.notes.core;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.model.tag.Tag;
import ru.yandex.chemodan.app.notes.core.model.tag.TagBase;
import ru.yandex.chemodan.app.notes.core.model.tag.TagPatch;

/**
 * @author tolmalev
 */
public interface TagsManager {

    ListF<Tag> listTags(DataApiUserId uid);
    ResultWithRevision<Tag> createTag(DataApiUserId uid, TagBase tagBase);
    ResultWithRevision<Void> deleteTag(DataApiUserId uid, long id);
    ResultWithRevision<?> patchTag(DataApiUserId uid, long id, TagPatch patch, Option<String> requestId);

}
