package ru.yandex.chemodan.app.notes.core.model.notes;

import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 * @author vpronto
 */
@BenderBindAllFields
@ActionResultPojo
@Builder
@Data
public class Note {
    public final String id;

    public final String title;
    public final Instant ctime;
    public final Instant mtime;
    @BenderPart(name = "tags_with_meta", strictName = true)
    public final ListF<NoteTag> tagsWithMeta;
    public final ListF<Long> tags;
    public final Option<String> snippet;
    @BenderPart(name = "attach_resource_ids", strictName = true)
    public final ListF<String> attachResourceIds;
    @BenderPart(name = "content_revision", strictName = true)
    public final Option<Long> contentRevision;

}
