package ru.yandex.chemodan.app.notes.core.model.notes;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 * @author vpronto
 */
@Bendable
@BenderBindAllFields
@Data
public class NoteCreation {
    public final String title;

    public final Option<Instant> ctime;
    public final Option<Instant> mtime;

    @BenderPart(name = "tags_with_meta", strictName = true)
    public final ListF<NoteTag> tagsWithMeta;
    public final ListF<Long> tags;
    public final Option<String> snippet;
    @BenderPart(name = "attach_resource_ids", strictName = true, wrapperName = "attach_resource_ids")
    public final Option<ListF<String>> attachResourceIds;
    @BenderPart(name = "content_revision", strictName = true)
    public final Option<Long> contentRevision;

    public Note toNote(String id) {
        return Note.builder()
                .id(id)
                .title(title)
                .ctime(ctime.getOrElse(Instant.now()))
                .mtime(mtime.getOrElse(Instant.now()))
                .tagsWithMeta(Cf.toList(tagsWithMeta).plus(tags.map(i -> NoteTag.builder().id(i).mtime(mtime).build())))
                .tags(Cf.toList(tags).plus(tagsWithMeta.map(t -> t.id)))
                .snippet(snippet)
                .attachResourceIds(attachResourceIds.getOrElse(Cf.list()))
                .contentRevision(contentRevision)
                .build();
    }

    public NoteCreation withoutInnerFields() {
        return new NoteCreation(title, ctime, mtime, tagsWithMeta, tags, snippet, Option.empty(), Option.empty());
    }

}
