package ru.yandex.chemodan.app.notes.core.model.notes;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 * @author vpronto
 */
@Bendable
@BenderBindAllFields
@Data
@AllArgsConstructor
@Builder
public class NotePatch {
    public final Option<String> title;
    public final Option<String> snippet;

    public final Option<Instant> mtime;

    @BenderPart(name = "add_tags", strictName = true)
    public final SetF<Long> addTags;
    @BenderPart(name = "add_tags_with_meta", strictName = true)
    public final SetF<NoteTag> addTagsWithMeta;
    @BenderPart(name = "remove_tags", strictName = true)
    public final SetF<Long> removeTags;

    @BenderPart(name = "content_revision", strictName = true)
    public final Option<Long> contentRevision;

    public ListF<NoteTag> getAllAddTagsMeta() {
        return Cf.toSet(addTags).map(aLong -> NoteTag.builder().id(aLong).mtime(mtime).build()).plus(addTagsWithMeta);
    }

    public NotePatch withoutContentRevision() {
        return new NotePatch(title, snippet, mtime, addTags, addTagsWithMeta, removeTags, Option.empty());
    }
}
