package ru.yandex.chemodan.app.notes.core.model.notes;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@ActionResultPojo
@BenderBindAllFields
@Data
public class NoteWithMdsKey {
    @BenderFlatten
    private final Note note;
    @BenderPart(name = "content_mds_key", strictName = true)
    private final Option<MdsFileKey> contentMdsKey;
}
