package ru.yandex.chemodan.app.notes.core.model.tag;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@ActionResultPojo
public class Tag extends TagBase {

    public final long id;

    public Tag(long id, TagType type, Option<String> value) {
        super(type, value);
        this.id = id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return builder()
                .id(id)
                .value(value)
                .type(type);
    }

    public static final class Builder {
        private long id;
        public TagType type;
        public Option<String> value;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder type(TagType type) {
            this.type = type;
            return this;
        }

        public Builder value(Option<String> value) {
            this.value = value;
            return this;
        }

        private Builder() {
        }

        public Tag build() {
            return new Tag(id, type, value);
        }

    }
}
