package ru.yandex.chemodan.app.notes.core.model.tag;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@Data
public class TagBase {
    public final TagType type;
    public final Option<String> value;

    public TagBase(TagBase tagBase) {
        this(tagBase.type, tagBase.value);
    }

    public TagBase(TagType type, Option<String> value) {
        this.type = type;
        this.value = value;
    }

    public Tag toTag(long id) {
        return new Tag(id, type, value);
    }
}
