package ru.yandex.chemodan.app.notes.core.model.tag;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class TagPatch {
    public final Option<String> value;

    public TagPatch(Option<String> value) {
        this.value = value;
    }

    public RecordChange toRecordChange(RecordId dataRecordId) {
        return RecordChange.update(dataRecordId,
                value.map(v -> FieldChange.put("value", DataField.string(v))
        ));
    }

    public boolean needPatch(Tag actualTag) {
        return value.isPresent()
                && !value.equals(actualTag.value);
    }
}
