package ru.yandex.chemodan.app.notes.core.model.tag;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author tolmalev
 */
public enum TagType {
    TRASH(0L),
    DELETED(1L),
    PIN(2L),
    TEXT
    ;

    private final Option<Long> predefinedId;
    private final boolean singleton;

    TagType(Long predefinedId) {
        this.predefinedId = Option.of(predefinedId);
        this.singleton = true;
    }

    TagType(boolean singleton) {
        this.predefinedId = Option.empty();
        this.singleton = singleton;
    }

    TagType() {
        this.predefinedId = Option.empty();
        this.singleton = false;
    }

    public boolean isSystem() {
        return predefinedId.isPresent();
    }

    public long getPredefinedId() {
        return predefinedId.get();
    }

    public boolean isSingleton() {
        return singleton;
    }

    public static final EnumResolver<TagType> R = EnumResolver.er(TagType.class);
}
