package ru.yandex.chemodan.app.notes.dao;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ToStringSerializable;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author vpronto
 */
public class BaseDao<T> {

    private final JdbcTemplate3 jdbcTemplate;
    private final RowMapper<T> mapper;

    public BaseDao(JdbcTemplate3 jdbcTemplate, RowMapper<T> mapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = mapper;
    }

    public boolean update(String q, Object... args) throws DataAccessException {
        int update = jdbcTemplate.update(q, process(args));
        return update > 0;
    }

    private Object process(Object[] args) {
        for (int i = 0; i < args.length; i++) {
            if (args[i] instanceof ToStringSerializable) {
                args[i] = ((ToStringSerializable)args[i]).serialize();
            }
        }
        return args;
    }

    Option<T> queryForOption(String q, Object ... args) {
        return jdbcTemplate.queryForOption(q, mapper, process(args));
    }

    ListF<T> query(String q, Object ... args) {
        return jdbcTemplate.query(q, mapper, process(args));
    }

}
