package ru.yandex.chemodan.app.notes.dao;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.dao.model.NoteRecord;

/**
 * @author vpronto
 */
public interface NotesDao {

    NoteRecord create(NoteRecord record);
    boolean softDelete(DataApiUserId uid, String id);
    boolean delete(DataApiUserId uid, String id);
    Option<NoteRecord> findNote(DataApiUserId uid, String id);
    ListF<NoteRecord> findNotes(DataApiUserId uid);
    boolean update(NoteRecord record);
    void updateMtime(DataApiUserId uid, String id, Instant mtime);
    void updateRevision(DataApiUserId uid, String id, Long lastRevision);

}
