package ru.yandex.chemodan.app.notes.dao;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notes.dao.model.ModelHelper;
import ru.yandex.chemodan.app.notes.dao.model.RequestRecord;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author vpronto
 */
public class NotesRequestsDaoImpl extends BaseDao<RequestRecord> implements NotesRequestsDao {

    private final static RowMapper<RequestRecord> M = (RowMapper<RequestRecord>) (rs, rowNum) -> RequestRecord.builder()
            .uid(ModelHelper.toUserId(rs.getString("uid")))
            .requestId(rs.getString("request_id"))
            .entityId(rs.getString("entity_id"))
            .revision(rs.getLong("revision"))
            .build();

    public NotesRequestsDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate, M);
    }

    @Override
    public boolean create(RequestRecord record) {
        String q = "INSERT INTO request(uid, request_id, entity_id, revision) values (?, ?, ?, ?) ON CONFLICT DO NOTHING";
        return update(q, record.uid, record.requestId, record.entityId, record.revision);
    }

    @Override
    public boolean update(RequestRecord record) {
        String q = "UPDATE request SET entity_id = ?, revision = ? WHERE uid = ? and request_id = ?";
        return update(q, record.entityId, record.revision, record.uid, record.requestId);
    }

    @Override
    public boolean delete(RequestRecord record) {
        String q = "DELETE FROM request WHERE uid = ? and request_id = ?";
        return update(q, record.uid, record.requestId);
    }

    @Override
    public Option<RequestRecord> find(RequestRecord record) {
        String q = "SELECT uid, request_id, entity_id, revision FROM request WHERE uid = ? and request_id = ?";
        return queryForOption(q, record.uid, record.requestId);
    }

}
