package ru.yandex.chemodan.app.notes.dao.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author vpronto
 */
@Configuration
@Import({
        NotesJdbcContextConfiguration.class,
})
@ConditionalOnMissingEmbeddedDb
public class DataSourceNotesContextConfiguration {

    @Bean
    @OverridableValuePrefix("notes")
    public DataSourceProperties notesDataSourceProperties() {
        return new DataSourceProperties();
    }

}
