package ru.yandex.chemodan.app.notes.dao.configuration;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.notes.dao.NotesDao;
import ru.yandex.chemodan.app.notes.dao.NotesDaoImpl;
import ru.yandex.chemodan.app.notes.dao.NotesRequestsDao;
import ru.yandex.chemodan.app.notes.dao.NotesRequestsDaoImpl;
import ru.yandex.chemodan.app.notes.dao.NotesRevisionsDao;
import ru.yandex.chemodan.app.notes.dao.NotesRevisionsDaoImpl;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author vpronto
 */
@Configuration
@Import({
        ConductorContextConfiguration.class,
        JdbcDatabaseConfiguratorContextConfiguration.class,
})
public class NotesJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;


    @Bean
    public JdbcDatabaseConfigurator notesDbConfigurator(DataSourceProperties notesDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(notesDataSourceProperties);
    }

    @Bean
    public DataSource notesDataSource(JdbcDatabaseConfigurator notesDbConfigurator) {
        return notesDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 notesJdbcTemplate(
            JdbcDatabaseConfigurator notesDbConfigurator, DataSource notesDataSource)
    {
        return notesDbConfigurator.consTemplate(notesDataSource);
    }

    @Bean
    public NotesDao notesDao(JdbcTemplate3 notesJdbcTemplate) {
        return new NotesDaoImpl(notesJdbcTemplate);
    }

    @Bean
    public NotesRevisionsDao revisionDao(JdbcTemplate3 notesJdbcTemplate) {
        return new NotesRevisionsDaoImpl(notesJdbcTemplate);
    }

    @Bean
    public NotesRequestsDao requestDao(JdbcTemplate3 notesJdbcTemplate) {
        return new NotesRequestsDaoImpl(notesJdbcTemplate);
    }

}
