package ru.yandex.chemodan.app.notes.dao.model;

import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.inside.mds.MdsFileKey;

/**
 * @author vpronto
 */
@Builder(toBuilder = true)
@Data
public class RevisionRecord {

    public final DataApiUserId uid;
    public final String noteId;
    public final Long revision;
    public final Instant serverTime;
    public final Instant clientTime;
    public final DataApiUserId authorUid;
    public final String delta;
    public final MdsFileKey deltaMdsKey;
    public final MdsFileKey originalDeltaMdsKey;
    public final MdsFileKey snapshotMdsKey;

}
