package ru.yandex.chemodan.app.notes.tasks;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
})
public class NotesBazingaWorkerContextConfiguration {
    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(NotesTaskQueueName.CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${notes.sync-attach-resource-ids.tasks.count}")
                    int syncAttachResourceIdsThreadCount,
            @Value("${notes.sync-attach-resource-ids.tasks.queue}")
                    int syncAttachResourceIdsQueueCount,
            @Value("${notes.remove-deleted-notes.tasks.count}")
                    int removeDeletedNotesThreadCount,
            @Value("${notes.remove-deleted-notes.tasks.queue}")
                    int removeDeletedNotesQueueCount)
    {
        TaskQueue syncAttachResourceIdsQueue = new TaskQueue(NotesTaskQueueName.SYNC_ATTACH_RESOURCE_IDS,
                syncAttachResourceIdsThreadCount, syncAttachResourceIdsQueueCount);
        TaskQueue removeDeletedNotesQueue = new TaskQueue(NotesTaskQueueName.REMOVE_DELETED_NOTES,
                removeDeletedNotesThreadCount, removeDeletedNotesQueueCount);

        return new BazingaWorkerTaskQueues(
                NotesTaskQueueName.CRON, NotesTaskQueueName.REGULAR, NotesTaskQueueName.CPU_INTENSIVE,
                Cf.list(syncAttachResourceIdsQueue, removeDeletedNotesQueue));
    }

    @Bean
    public SyncAttachResourceIdsTask syncAttachResourceIdsTask(NotesManager notesManager) {
        return new SyncAttachResourceIdsTask(notesManager);
    }

    @Bean
    public RemoveDeletedNotesTask removeDeletedNotesTask(NotesManager notesManager) {
        return new RemoveDeletedNotesTask(notesManager);
    }

}
