package ru.yandex.chemodan.app.notes.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class RemoveDeletedNotesTask extends OnetimeTaskSupport<RemoveDeletedNotesTask.Parameters> {

    private final NotesManager notesManager;

    public RemoveDeletedNotesTask(DataApiUserId uid) {
        super(new Parameters(uid));
        this.notesManager = null;
    }

    public RemoveDeletedNotesTask(NotesManager notesManager) {
        super(Parameters.class);
        this.notesManager = notesManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        DataApiUserId uid = parameters.uid;
        notesManager.removeDeletedNotes(uid, true);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return NotesTaskQueueName.REMOVE_DELETED_NOTES;
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final DataApiUserId uid;
    }
}
