package ru.yandex.chemodan.app.notes.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notes.core.NotesManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */

public class SyncAttachResourceIdsTask extends OnetimeTaskSupport<SyncAttachResourceIdsTask.Parameters> {

    private final NotesManager notesManager;

    public SyncAttachResourceIdsTask(DataApiUserId uid, String noteId) {
        super(new Parameters(uid, noteId));
        this.notesManager = null;
    }

    public SyncAttachResourceIdsTask(NotesManager notesManager) {
        super(Parameters.class);
        this.notesManager = notesManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        notesManager.synchronizeAttachments(parameters.uid, parameters.noteId, Option.empty());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(30);
    }

    @Override
    public TaskQueueName queueName() {
        return NotesTaskQueueName.SYNC_ATTACH_RESOURCE_IDS;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final DataApiUserId uid;
        private final String noteId;
    }

}
