package ru.yandex.chemodan.app.notifier;

import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.NewNotificationData;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.io.http.UrlUtils;

@RequiredArgsConstructor
public class CloudNotificationClient implements NotificationClient {

    private final DynamicProperty<Boolean> useLocalClient = new DynamicProperty<>("use-local-notification-manager", false);
    private final NotificationManager manager;
    private final HttpClient httpClient;
    private final String url;

    public static MapF<String, String> serialize(NewNotificationData data) {
        return Cf
                .map("service", Option.of(data.type.getService().name))
                .plus1("type", Option.of(data.type.name))
                .plus1("meta", Option.of(data.metadata.toJsonString()))
                .plus1("groupKey", Option.of(data.groupKey))
                .plus1("actor", Option.of(data.actor.serialize()))
                .plus1("uid", Option.of(data.owner.serialize()))
                .plus1("subscriptionKey", data.subscriptionKey)
                .filterValues(Option::isPresent)
                .mapValues(Option::get);
    }

    @Override
    @SneakyThrows
    public void createNewNotification(NewNotificationData data) {
        if (useLocalClient.get()) {
            manager.createNewNotification(data);
        } else {
            httpClient.execute(new HttpPost(UrlUtils.addParameters(url + "/add-notification", serialize(data))));
        }
    }

}
