package ru.yandex.chemodan.app.notifier;

import java.util.UUID;

import lombok.SneakyThrows;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.chemodan.app.notifier.actions.AddNotificationAction;
import ru.yandex.chemodan.app.notifier.admin.dao.test.ActivateNotificationEmbeddedPg;
import ru.yandex.chemodan.app.notifier.grants.ServiceGrantsChecker;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NewNotificationData;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationTypeManagerTestContextConfiguration;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.parameter.convert.DefaultConverters;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.web.servlet.mock.MockHttpServletRequest;
import ru.yandex.misc.web.servlet.mock.MockHttpServletResponse;

@ActivateDataApiEmbeddedPg
@ActivateNotificationEmbeddedPg
@ContextConfiguration(classes = NotificationTypeManagerTestContextConfiguration.class)
public class CloudNotificationClientTest extends DataApiTestSupport  {

    @Autowired
    private NotificationRecordTypeManager typeManager;

    @Test
    public void testWithSubscription() {
        addNotification(new NewNotificationData(
                DataApiUserId.parse(Long.toString(1000 + Math.round(Math.random() * 9000))),
                NotificationActor.YA_DISK,
                Option.of(UUID.randomUUID().toString()),
                UUID.randomUUID().toString(),
                typeManager.resolveRecordType("autoupload", "disk"),
                MetadataWrapper.createEmpty()));
    }

    @Test
    public void testWithoutSubscription() {
        addNotification(new NewNotificationData(
                DataApiUserId.parse(Long.toString(1000 + Math.round(Math.random() * 9000))),
                NotificationActor.YA_DISK,
                Option.empty(),
                UUID.randomUUID().toString(),
                typeManager.resolveRecordType("autoupload", "disk"),
                MetadataWrapper.createEmpty()));
    }

    @SneakyThrows
    private void addNotification(NewNotificationData data) {
        ListF<NewNotificationData> invocations = Cf.linkedList();
        NotificationManager notificationManager = Mockito.mock(NotificationManager.class);
        Mockito.doAnswer(t -> {
            invocations.add(t.getArgument(0));
            return null;
        }).when(notificationManager).createNewNotification(Mockito.any());
        ActionConfigurator.configure(
                Cf.list(new AddNotificationAction(notificationManager, typeManager, new ServiceGrantsChecker(true))),
                ActionConfigurationBuilder
                        .cons(new ApplicationInfo("test", "42"))
                        .setConverters(DefaultConverters.all().getConverters())
        ).createServlet().service(
                new MockHttpServletRequest() {{
                    setMethod("POST");
                    setPathInfo("/add-notification");
                    CloudNotificationClient.serialize(data).forAllEntries((k, v) -> {
                        addParameter(k, v);
                        return true;
                    });
                }},
                new MockHttpServletResponse()
        );
        Assert.equals(invocations, Cf.list(data));
    }

}
