package ru.yandex.chemodan.app.notifier;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.OrderedUUID;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntity;
import ru.yandex.chemodan.app.notifier.metadata.MetadataEntityType;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationService;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskGroups;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskIcons;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskNotifications;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskServices;
import ru.yandex.chemodan.app.notifier.worker.metadata.MetadataEntityNames;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUids;
import ru.yandex.misc.random.Random2;

/**
 * @author akirakozov
 */
public class NotificationTestUtils {
    public static final NotificationType NOTIFICATION_TYPE_FOR_TESTS = new NotificationType(
            Option.of(1), Option.of(1), DiskNotifications.COMMENT_LIKE.getType(),
            Option.of(new NotificationGroup(DiskGroups.LIKES.getGroup(),
                    new NotificationService(Option.empty(), DiskServices.DISK, "keyset", false))),
            DiskIcons.LIKE, "message", "title", "short", Option.empty(),
            new CounterConfiguration(CounterType.UNIQUE_BUT_ONE, Cf.list("actor.uid")),
            MetadataWrapper.createEmpty(), Duration.ZERO, Cf.list());

    public static NotificationActor createRandomActor() {
        long uid = Random2.R.nextLong(PassportUids.FIRST_YANDEX_TEAM);
        uid = uid == 0L ? 1 : uid;
        return NotificationActor.consFromUid(new PassportUid(uid));
    }

    public static NotificationBlockRecord createTestNotificationBlockRecord(String groupKey) {
        return createTestNotificationBlockRecord(groupKey, Option.empty(), NOTIFICATION_TYPE_FOR_TESTS);
    }

    public static NotificationBlockRecord createTestNotificationBlockRecord(String groupKey, Instant time) {
        return createTestNotificationBlockRecord(groupKey, Option.of(time), NOTIFICATION_TYPE_FOR_TESTS);
    }

    public static NotificationBlockRecord createTestNotificationBlockRecord(
            String groupKey, Option<Instant> time, NotificationType type)
    {
        Instant ctime = time.getOrElse(Instant.now());

        NotificationActor actor = createRandomActor();
        return new NotificationBlockRecord(
                OrderedUUID.generateOrderedUUID(),
                Cf.list(actor.serialize()),
                groupKey,
                type,
                Option.of(1L),
                new MetadataWrapper(Cf.map(MetadataEntityNames.ACTOR, new MetadataEntity(MetadataEntityType.USER,
                        Cf.map("uid", actor.serialize())))),
                "actor", Option.of("resource"), "action", ctime, ctime, false, Option.empty());
    }

    public static NotificationRecord createTestNewNotificationRecord(String groupKey) {
        return createTestNewNotificationRecord(groupKey, Option.empty());
    }

    public static NotificationRecord createTestNewNotificationRecord(String groupKey, Instant time) {
        return createTestNewNotificationRecord(groupKey, Option.of(time));
    }

    public static NotificationRecord createTestNewNotificationRecord(String groupKey, Option<Instant> time) {
        return createTestNewNotificationRecord(NOTIFICATION_TYPE_FOR_TESTS, groupKey, time);
    }

    public static NotificationRecord createTestNewNotificationRecord(
            NotificationType recordType, String groupKey, Option<Instant> time)
    {
        Instant ctime = time.getOrElse(Instant.now());

        MapF<String, MetadataEntity> metadata = Cf.hashMap();
        MapF<String, String> metadataRecord = Cf.hashMap();
        metadataRecord.put("field1", "field1Value");
        metadataRecord.put("field2", "field2Value");
        metadata.put("key1", new MetadataEntity(MetadataEntityType.COMMENT, metadataRecord));

        metadataRecord = Cf.hashMap();
        metadataRecord.put("field3", "field3Value");
        metadataRecord.put("field4", "field4Value");
        metadata.put("key2", new MetadataEntity(MetadataEntityType.USER, metadataRecord));

        metadataRecord = Cf.hashMap();
        metadataRecord.put("id", "12323:resource-id");
        metadata.put(MetadataEntityNames.ENTITY, new MetadataEntity(MetadataEntityType.RESOURCE, metadataRecord));

        NotificationActor actor = createRandomActor();

        metadataRecord = Cf.hashMap();
        metadataRecord.put("uid", actor.serialize());
        metadata.put(MetadataEntityNames.ACTOR, new MetadataEntity(MetadataEntityType.USER, metadataRecord));

        return new NotificationRecord(
                OrderedUUID.generateOrderedUUID(),
                actor,
                Option.of(actor.toString() + ":" + groupKey),
                groupKey,
                recordType,
                new MetadataWrapper(metadata),
                ctime);
    }

    public static NotificationRecord createDefaultNotificationRecord(String groupKey, NotificationType type) {
        Instant ctime = Instant.now();

        MapF<String, MetadataEntity> metadata = Cf.hashMap();
        MapF<String, String> metadataRecord = Cf.hashMap();
        NotificationActor actor = createRandomActor();
        metadataRecord.put("uid", actor.serialize());
        metadata.put(MetadataEntityNames.ACTOR, new MetadataEntity(MetadataEntityType.USER, metadataRecord));

        return new NotificationRecord(
                OrderedUUID.generateOrderedUUID(),
                actor,
                Option.empty(),
                groupKey,
                type,
                new MetadataWrapper(metadata),
                ctime);
    }

}
