package ru.yandex.chemodan.app.notifier;

import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.web.admin.DataApiCoreAdminContextConfiguration;
import ru.yandex.chemodan.app.notifier.log.listener.NotifierLogListener;
import ru.yandex.chemodan.app.notifier.log.listener.bass.NotifierBassLogListener;
import ru.yandex.chemodan.app.notifier.log.listener.events.NotifierEventsLogListener;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.toggling.NotificationToggleRegistry;
import ru.yandex.chemodan.app.notifier.settings.NotificationsGlobalSettingsManager;
import ru.yandex.chemodan.logbroker.DiskLbConsumerContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;

/**
 * @author buberman
 */
@Configuration
@Import({
        DataApiCoreAdminContextConfiguration.class,
        DiskLbConsumerContextConfiguration.class,
})
public class NotificationsLoaderContextConfiguration {
    @Autowired
    @Qualifier("lbListenerExecutor")
    private ThreadPoolExecutor listenerExecutor;

    @Bean
    public NotifierEventsLogListener notifierEventsLogListener(
            NotificationManager notificationManager,
            MpfsClient mpfsClient,
            BleedingEdge bleedingEdge,
            DiskNotificationManager diskNotificationManager,
            NotificationRecordTypeManager notificationRecordTypeManager,
            NotificationToggleRegistry notificationToggleRegistry,
            NotificationsGlobalSettingsManager notificationsGlobalSettingsManager)
    {
        return new NotifierEventsLogListener(
                notificationManager,
                mpfsClient,
                bleedingEdge,
                diskNotificationManager,
                notificationRecordTypeManager,
                notificationToggleRegistry,
                notificationsGlobalSettingsManager);
    }

    @Bean
    public NotifierBassLogListener notifierBassLogListener(NotificationManager notificationManager,
            NotificationRecordTypeManager notificationRecordTypeManager) {
        return new NotifierBassLogListener(notificationManager, notificationRecordTypeManager);
    }

    @Bean
    public NotifierLogListener notifierLogListener(
            @Qualifier("quellerFallbackNotifierEventsLogListener") LogListener notifierEventsLogListener,
            @Qualifier("quellerFallbackNotifierBassLogListener") LogListener notifierBassLogListener)
    {
        return new NotifierLogListener(notifierEventsLogListener, notifierBassLogListener);
    }

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(NotifierLogListener notifierLogListener) {
        return new LbSimpleAsyncLineListener(notifierLogListener, listenerExecutor);
    }

    @Bean
    public BleedingEdge bleedingEdge() {
        return new BleedingEdge("notifier");
    }
}
