package ru.yandex.chemodan.app.notifier;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.notifier.log.listener.bass.NotifierBassLogListener;
import ru.yandex.chemodan.app.notifier.log.listener.bass.ProcessNotifierBassLogLineCeleryTask;
import ru.yandex.chemodan.app.notifier.log.listener.events.NotifierEventsLogListener;
import ru.yandex.chemodan.app.notifier.log.listener.events.ProcessNotifierEventsLogLineCeleryTask;
import ru.yandex.chemodan.eventlog.celery.QuellerFallbackEventsLogListener;
import ru.yandex.chemodan.queller.worker.CeleryJavaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.chemodan.queller.worker.CeleryTaskManagerContextConfiguration;

/**
 * @author bursy
 */
@Configuration
@Import({
        CeleryJavaWorkerContextConfiguration.class,
        CeleryTaskManagerContextConfiguration.class,
        NotificationsLoaderContextConfiguration.class
})
public class NotifierCeleryContextConfiguration {
    @Bean
    public QuellerFallbackEventsLogListener quellerFallbackNotifierEventsLogListener(
            NotifierEventsLogListener notifierEventsLogListener,
            CeleryTaskManager celeryTaskManager,
            @Value("${notifier.queller.retry.count}") int retryCount) {
        return new QuellerFallbackEventsLogListener(notifierEventsLogListener, celeryTaskManager, retryCount,
                ProcessNotifierEventsLogLineCeleryTask::new);
    }

    @Bean
    public ProcessNotifierEventsLogLineCeleryTask processNotifierEventsLogLineCeleryTask(
            NotifierEventsLogListener notifierEventsLogListener)
    {
        return new ProcessNotifierEventsLogLineCeleryTask(notifierEventsLogListener);
    }

    @Bean
    public QuellerFallbackEventsLogListener quellerFallbackNotifierBassLogListener(
            NotifierBassLogListener notifierBassLogListener,
            CeleryTaskManager celeryTaskManager,
            @Value("${notifier.queller.retry.count}") int retryCount) {
        return new QuellerFallbackEventsLogListener(notifierBassLogListener, celeryTaskManager, retryCount,
                ProcessNotifierBassLogLineCeleryTask::new);
    }

    @Bean
    public ProcessNotifierBassLogLineCeleryTask processNotifierBassLogLineCeleryTask(
            NotifierBassLogListener notifierBassLogListener)
    {
        return new ProcessNotifierBassLogLineCeleryTask(notifierBassLogListener);
    }
}
