package ru.yandex.chemodan.app.notifier;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.notifier.admin.web.NotifierTypesAdminContextConfiguration;
import ru.yandex.chemodan.app.notifier.client.NotifierDaemonContextConfiguration;
import ru.yandex.chemodan.app.notifier.worker.NotificationWorkerContextConfiguration;
import ru.yandex.chemodan.app.notifier.worker.metadataprocessor.NotifierMetadataProcessorsConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.boot.admin.ChemodanAdminDaemonContextConfiguration;
import ru.yandex.chemodan.util.tvm2.CloudApiTvm2ServletFilterContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration;
import ru.yandex.misc.version.AppName;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        ChemodanCommonContextConfiguration.class,
        ChemodanAdminDaemonContextConfiguration.class,
        NotifierTypesAdminContextConfiguration.class,
        NotificationBaseContextConfiguration.class,
        NotificationWorkerContextConfiguration.class,
        NotifierDaemonContextConfiguration.class,
        NotificationsLoaderContextConfiguration.class,
        NotifierCeleryContextConfiguration.class,
        NotifierMetadataProcessorsConfiguration.class,
        Tvm2ServletFilterContextConfiguration.class,
        CloudApiTvm2ServletFilterContextConfiguration.class
})
public class NotifierContextConfiguration {

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, DiskAppVersion appVersion) {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }
}
