package ru.yandex.chemodan.app.notifier.actions;

import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author buberman
 */
@Path(value = "/check-resource-subscription", methods = {HttpMethod.GET, HttpMethod.POST})
public class CheckResourceSubscriptionAction extends ResourceSubscriptionBaseAction {
    @RequestParam("resourceId")
    private String resource;

    @RequestParam("notificationGroup")
    private String notificationGroup;

    public CheckResourceSubscriptionAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        super(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Override
    public Object execute() {
        boolean subscribed = notificationsSettingsManager.isSubscribed(getSubscriberUid(), resource,
                notificationRecordTypeManager.resolveNotificationGroupName(notificationGroup, getService()));
        return Boolean.toString(subscribed);
    }
}
