package ru.yandex.chemodan.app.notifier.actions;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.convert.ConverterToDataApiUserId;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author bursy
 */
@Path(value = "/api/delete-notification", methods = {HttpMethod.DELETE})
@RequiredArgsConstructor
public class DeleteNotificationAction implements CloneableAction {
    @RequestParam(value = "uid", customConverter = ConverterToDataApiUserId.class)
    private DataApiUserId uid;
    @RequestParam
    private String type;
    @RequestParam
    private String service;
    @RequestParam(value = "groupKey")
    private String groupKey;

    private final NotificationManager notificationManager;
    private final NotificationRecordTypeManager notificationRecordTypeManager;

    @Override
    public Object execute() throws Exception {
        NotificationType notificationType = notificationRecordTypeManager.resolveRecordType(type, service);

        notificationManager.deleteNotificationBlock(uid, notificationType, groupKey);

        return new OkPojo();
    }
}
