package ru.yandex.chemodan.app.notifier.actions;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndGroup;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author buberman
 */
@Path(value = "/enable-resource-notifications", methods = {HttpMethod.GET, HttpMethod.POST})
public class EnableResourceNotificationsAction extends ResourceSubscriptionBaseAction {
    @RequestParam("resourceId")
    private String resource;

    @RequestParam("notificationGroups")
    private Option<String> notificationGroups;

    public EnableResourceNotificationsAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        super(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Override
    public Object execute() {
        ListF<ServiceAndGroup> typesToRemove;
        if (notificationGroups.isPresent()) {
            typesToRemove = Cf.set(notificationGroups.get().split(","))
                    .map(group -> notificationRecordTypeManager.resolveNotificationGroupName(group, getService()));
        } else {
            typesToRemove = notificationRecordTypeManager.getNotificationGroupNames(getService());
        }

        notificationsSettingsManager.enableResourceNotifications(getSubscriberUid(), resource, typesToRemove.unique());
        return new OkPojo();
    }
}
