package ru.yandex.chemodan.app.notifier.actions;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.chemodan.app.notifier.settings.SettingsRecordPojo;
import ru.yandex.chemodan.app.notifier.settings.UserSettingsPojo;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;

/**
 * @author buberman
 */
@Path(value = "/get-all-resources-status", methods = {HttpMethod.GET, HttpMethod.POST})
public class GetAllUnsubscribedResourcesAction extends ResourceSubscriptionBaseAction {

    public GetAllUnsubscribedResourcesAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        super(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Override
    public Object execute() {
        ListF<SettingsRecordPojo> subscribedResources = notificationsSettingsManager
                .getSubscribedResources(getSubscriberUid(), getService(), Option.empty())
                .map(record -> SettingsRecordPojo.cons(record, notificationRecordTypeManager, getService()));
        return new UserSettingsPojo(owner.toString(), subscribedResources);
    }
}
