package ru.yandex.chemodan.app.notifier.actions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.chemodan.app.notifier.settings.SettingsRecordPojo;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author buberman
 */
@Path(value = "/get-resource-notification-settings", methods = {HttpMethod.GET, HttpMethod.POST})
public class GetResourceNotificationsSettingsAction extends ResourceSubscriptionBaseAction {
    @RequestParam("resourceId")
    private String resource;

    public GetResourceNotificationsSettingsAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        super(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Override
    public Object execute() {
        SettingsRecordPojo subscribedResource = notificationsSettingsManager
                .getSubscribedResources(getSubscriberUid(), getService(), Option.of(resource))
                .map(record -> SettingsRecordPojo.cons(record, notificationRecordTypeManager, getService()))
                .singleO()
                .getOrElse(SettingsRecordPojo.subscribedToAll(notificationRecordTypeManager, resource, getService()));
        return subscribedResource;
    }
}
